	function src = hdlsources(hdlspec, hdlconf)
	%src = hdlsources(hdlspec, hdlconf)
	%
	%Arguments:
	%  hdlspec - HDL specification structure
	%  hdlconf - HDL configuration
	%
	%Returns:
	%  src - list of VHDL sources specified by hdlspec
	
	%Copyright 2008, 2010 Anton Blad
	%
	%This file is part of firgen.
	%
	%firgen is free software: you can redistribute it and/or modify
	%it under the terms of the GNU General Public License as published by
	%the Free Software Foundation, either version 3 of the License, or
	%(at your option) any later version.
	%
	%firgen is distributed in the hope that it will be useful,
	%but WITHOUT ANY WARRANTY; without even the implied warranty of
	%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	%GNU General Public License for more details.
	%
	%You should have received a copy of the GNU General Public License
	%along with firgen.  If not, see <http://www.gnu.org/licenses/>
	
	src = {};
	
	for n = 1:length(hdlspec.components)
		src = {src{:}, strcat(hdlspec.components(n).iface.name, '.vhdl')}';
	end
	
